// ==UserScript==
// @name         5ch サブドメイン突破簡易OGPカード表示試作
// @namespace    http://tampermonkey.net/
// @version      0.1
// @description  別サブドメインの5chスレからデータ取得してOGP風カードを表示
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// @run-at       document-idle
// ==/UserScript==

(function () {
    'use strict';

    const isTopWindow = (window === window.parent);

    if (isTopWindow) {
        // === 親ページ処理 ===
        console.log("[5chカード] 親ページとして動作中");

        // iframeからのメッセージ受信
        window.addEventListener("message", (event) => {
            if (!event.origin.endsWith(".5ch.net")) return;
            if (!event.data || !event.data.title || !event.data.threadId) return;

            console.log("[5chカード] 受信データ:", event.data);

            const card = document.createElement("div");
            card.style.cssText = "border:1px solid #aaa; padding:10px; margin:10px; background:#f9f9f9;";
            card.innerHTML = `
                <strong>${event.data.title}</strong><br>
                スレID: ${event.data.threadId}<br>
                <div style="margin-top:5px; font-size:90%; color:#444;">
                    <div><strong>レス1:</strong></div>
                    <div>${event.data.res1}</div>
                </div>
            `;
            document.body.appendChild(card);
        });

        // 他サブドメインリンクを検出してiframeで読み込み
        const links = Array.from(document.querySelectorAll("a[href*='5ch.net/test/read.cgi/']"));
        links.forEach(link => {
            try {
                const url = new URL(link.href);
                if (url.hostname !== location.hostname) {
                    console.log(`[5chカード] 外部5chリンク検出: ${url.href}`);
                    const iframe = document.createElement("iframe");
                    iframe.style.cssText = "width:0;height:0;display:none;";
                    iframe.src = url.href;
                    document.body.appendChild(iframe);
                }
            } catch (e) {
                console.warn("[5chカード] URL解析エラー:", e);
            }
        });

    } else {
        // === iframe側処理 ===
        console.log("[5chカード] iframe側として動作中");

        // DOMの描画完了後にデータ取得と送信
        setTimeout(() => {
            const threadTitle = document.querySelector('#threadtitle')?.textContent?.trim() || "（タイトル未取得）";
            const res1Elem = document.querySelector('#1');
            const res1 = res1Elem ? res1Elem.innerHTML.trim() : "（レス1未取得）";
            const pathParts = location.pathname.split('/');
            const threadId = pathParts[4] || "（ID不明）";

            const payload = {
                title: threadTitle,
                threadId: threadId,
                res1: res1,
                origin: location.hostname
            };

            window.parent.postMessage(payload, "*");
            console.log("[5chカード] 親に送信:", payload);
        }, 1000); // 遅延を調整（必要に応じて延長可）
    }
})();
